/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SliderWidget
extends Widget
implements ITickableWidget {
    private static final ResourceLocation SLIDER_TEXTURE = new ResourceLocation("movingelevators", "textures/gui/slider.png");
    private final int min;
    private final int max;
    private final int range;
    private int value;
    private int lastValue;
    private final Function<Integer, Component> text;
    private final Consumer<Integer> onChange;
    private boolean dragging = false;

    public SliderWidget(int x, int y, int width, int min, int max, int startValue, Function<Integer, Component> text, Consumer<Integer> onChange) {
        super(x, y, width, 11);
        if (max < min) {
            throw new IllegalArgumentException("Maximum must be greater than the minimum!");
        }
        if (startValue < min || startValue > max) {
            throw new IllegalArgumentException("Start value must be between the minimum and maximum!");
        }
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.value = this.lastValue = startValue;
        this.text = text;
        this.onChange = onChange;
    }

    protected Component getNarrationMessage() {
        return this.text.apply(this.value);
    }

    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.dragging) {
            this.value = Math.min(this.max, Math.max(this.min, Math.round((float)(mouseX - this.x) / (float)this.width * (float)this.range) + this.min));
        }
        ScreenUtils.bindTexture((ResourceLocation)SLIDER_TEXTURE);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)this.x, (float)this.y, (float)1.0f, (float)this.height, (float)0.0f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(this.x + 1), (float)this.y, (float)(this.width - 2), (float)this.height, (float)0.055555556f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)(this.x + this.width - 1), (float)this.y, (float)1.0f, (float)this.height, (float)0.11111111f, (float)0.0f, (float)0.055555556f, (float)1.0f);
        float percentage = (float)(this.value - this.min) / (float)this.range;
        ScreenUtils.drawTexture((PoseStack)matrixStack, (float)((float)this.x + percentage * (float)(this.width - 5)), (float)this.y, (float)5.0f, (float)this.height, (float)(this.active ? (this.hovered || this.dragging ? 0.44444445f : 0.16666667f) : 0.7222222f), (float)0.0f, (float)0.2777778f, (float)1.0f);
        Component text = this.text.apply(this.value);
        if (text != null) {
            ScreenUtils.drawCenteredStringWithShadow((PoseStack)matrixStack, (Component)text, (float)((float)this.x + (float)this.width / 2.0f), (float)(this.y + 2), (int)0xE0E0E0);
        }
    }

    public void tick() {
        if (this.value != this.lastValue) {
            this.onChange.accept(this.value);
            this.lastValue = this.value;
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.hovered) {
            this.dragging = true;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.dragging = false;
    }

    public void mouseScrolled(int mouseX, int mouseY, double scroll) {
        if (this.hovered) {
            if (scroll > 0.0 && this.value < this.max) {
                ++this.value;
            } else if (scroll < 0.0 && this.value > this.min) {
                --this.value;
            }
        }
    }
}

